<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2016 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

define('FILE_ENCRYPTION_BLOCKS', 10000);


class CFile {

	//aslias to get Contents
	static function Get($file_name){
		return CFile::GetContents($file_name);
	}

	static function GetJSon($file_name , $assoc = true) {
		return json_decode(CFile::GetContents($file_name) , $assoc );
	}

	static function SaveJson($file_name , $data) {
		return CFile::SaveContents($file_name, json_encode($data) );
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function GetContents($file_name) {
		if (!file_exists($file_name)) {
//			return null;
		}
	
		$file = fopen($file_name,"r");
		
		//checking if the file was succesfuly opened
		if (!$file)
			return null;

		if (strstr($file_name,"://"))
			while (!feof($file))
				$result .= fread($file,1024);
		else
			$result = @fread($file,filesize($file_name));

		fclose($file);

		return $result;

	}

	static function Copy($source , $destination , $chmod = 0644) {

		if (file_exists($source)) {
			copy( $source ,$destination);
			
			if ($chmod != null) {
				chmod(
					$destination , 
					$chmod
				);
			}
			
			return true;
		}
		
	}

	static function Save($file_name , $content) {
		return CFile::SaveContents($file_name , $content);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function SaveContents($file_name , $content) {
		$file = fopen($file_name,"w");
		fwrite($file,$content);
		fclose($file);
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function Extension($file_name) {
		$tmp = explode("." , $file_name);
		return $tmp[count($tmp) - 1];
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function Name2Url($filename) {

		$replace = array(

				"À"	=>	"A",
				"Á"	=>	"A",
				"Â"	=>	"A",
				"Ã"	=>	"A",
				"Ä"	=>	"A",
				"Å"	=>	"A",
				"Ç"	=>	"C",
				"È"	=>	"E",
				"É"	=>	"E",
				"Ê"	=>	"E",
				"Ë"	=>	"E",
				"Ì"	=>	"I",
				"Í"	=>	"I",
				"Î"	=>	"I",
				"Ï"	=>	"I",
				"Ð"	=>	"D",
				"Ñ"	=>	"N",
				"Ò"	=>	"O",
				"Ó"	=>	"O",
				"Ô"	=>	"O",
				"Õ"	=>	"O",
				"Ö"	=>	"O",
				"Ù"	=>	"U",
				"Ú"	=>	"U",
				"Û"	=>	"U",
				"Ü"	=>	"U",
				"Ý"	=>	"Y",
				"Ţ"	=>	"T",
				"Ț"	=>   "T",
				"Ť"	=>	"T",
				"Š"	=>	"S",
				"Ş"	=>	"S",
				"Ș"	=>   "S",
				"Ŝ"	=>	"S",
				"Ś"	=>	"S",
				"Ř"	=>	"R",
				"Ŕ"	=>	"R",
				"Ń"	=>	"N",
				"Ņ"	=>	"N",
				"Ň"	=>	"N",

				
				"à"	=>	"a",
				"á"	=>	"a",
				"â"	=>	"a",
				"ã"	=>	"a",
				"ä"	=>	"a",
				"å"	=>	"a",
				"ç"	=>	"c",
				"è"	=>	"e",
				"é"	=>	"e",
				"ê"	=>	"e",
				"ë"	=>	"e",
				"ì"	=>	"i",
				"í"	=>	"i",
				"î"	=>	"i",
				"ï"	=>	"i",
				"ð"	=>	"d",
				"ñ"	=>	"n",
				"ò"	=>	"o",
				"ó"	=>	"o",
				"ô"	=>	"o",
				"õ"	=>	"o",
				"ö"	=>	"o",
				"ù"	=>	"u",
				"ú"	=>	"u",
				"û"	=>	"u",
				"ü"	=>	"u",
				"ý"	=>	"y",
				"ţ"	=>	"t",
				"ť"	=>	"t",
				"ț"	=>	"t",
				"š"	=>	"s",
				"ș"	=>   "s",					
				"ş"	=>	"s",
				"ŝ"	=>	"s",
				"ś"	=>	"s",
				"ř"	=>	"r",
				"ŕ"	=>	"r",
				"ń"	=>	"n",
				"ņ"	=>	"n",
				"ň"	=>	"n",

				" " => "-",
				"#" => "-",
				"&" => "-and-",
				"?" => "", 
				"=>" => "-", 
				")" => "-", 
				"(" => "-", 
				"{" => "-", 
				"}" => "-", 
				"'" => "-",
				"/" => "-",
				"!" => "",
				"," => "-",
				"\"" => "",
				"(" => "-",
				")" => "-",
				"'" => "",
				"'" => "",
				"--" => "-"
			);

		$filename = trim($filename);

		foreach ($replace as $key => $val) {
			$filename = str_replace($key , $val , $filename);
		}

		return strtolower($filename);
	}

	
	static function ReadChunked($filename,$retbytes=true) {
		$chunksize = 1*(1024*1024); // how many bytes per chunk
		$buffer = '';
		$cnt =0;
		// $handle = fopen($filename, 'rb');
		$handle = fopen($filename, 'rb');
		if ($handle === false) {
			return false;
		}
		while (!feof($handle)) {
			$buffer = fread($handle, $chunksize);
			echo $buffer;
			if ($retbytes) {
				$cnt += strlen($buffer);
			}
		}
			$status = fclose($handle);
		if ($retbytes && $status) {
			return $cnt; // return num. bytes delivered like readfile() does.
		} 
		return $status;

	} 


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function LoadArray($file , $header = false , $sep = "" , $ext = null) {

		if (!file_exists($file)) {
			return null;
		}
		

		$path = pathinfo($file);

		if ($ext != null) {
			$path["extension"] = $ext;
		}
		

		switch (strtolower($path["extension"])) {

			case "serial":
			case "serialized":
				return unserialize(
					CFile::GetContents($file)
				);
			break;

			case "txt":
				$data = file($file);

				if (count($data)) {
					foreach ($data as $key => $val) {
						$data[$key] = explode($sep , $val);
					}
				}
				
				if (($header == true) && count($data)) {
					$header_data = $data[0];
					unset($data[0]);
				}

			break;


			case "csv":
				if (($handle = fopen($file, "r")) !== FALSE) {
					while (($record = fgetcsv($handle, 1000, ",")) !== FALSE) {
						$data[] = $record;
					}
					fclose($handle);
				}

				if (($header == true) && count($data)) {
					$header_data = $data[0];
					unset($data[0]);
				}

			break;

			case "xls":
			case "xlsx":

				External::Load("phpexcel");
				$objPHPExcel = PHPExcel_IOFactory::load($file);
				$data = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);

				if (($header == true) && count($data)) {
					$header_data = $data[1];
					unset($data[1]);
				}

			break;
		}

		if ($header == true) {

			if (is_array($data) && count($data)) {
				foreach ($data as $key => $val) {

					$tmp = array();

					foreach ($val as $k => $v) {

						if ($header_data[$k]) {
							$tmp[$header_data[$k]] = $v;
						}
						
					}

					$data[$key]= $tmp;
				
				}
				
			}
			
		}

		return $data;

	}

	
	static function Remove($file) {

		if (file_exists($file)) {
			unlink($file);				
			return true;
		} else {
			return false;
		}	
	}

	static function CleanChars($filename) {
		$replace = array(
				" "  =>  "-",
				"."  =>  "",
				"-"  =>  "", 
			);

		foreach ($replace as $key => $val) {
			$filename = str_replace($key , $val , $filename);
		}

		return strtolower($filename);
	}


	static function FormatedSize($filename) {

		if (file_exists($filename)) {
			$bytes = filesize($filename);
		} else {
			$bytes = 0;
		}
		

		  if ($bytes >= 1073741824)
			{
				$bytes = number_format($bytes / 1073741824, 2) . ' GB';
			}
			elseif ($bytes >= 1048576)
			{
				$bytes = number_format($bytes / 1048576, 2) . ' MB';
			}
			elseif ($bytes >= 1024)
			{
				$bytes = number_format($bytes / 1024, 2) . ' KB';
			}
			elseif ($bytes > 1)
			{
				$bytes = $bytes . ' bytes';
			}
			elseif ($bytes == 1)
			{
				$bytes = $bytes . ' byte';
			}
			else
			{
				$bytes = '0 bytes';
			}

		return $bytes;
	}
	

	static function Crypt($key , $source , $dest) {

		$key = substr(sha1($key, true), 0, 16);
		$iv = openssl_random_pseudo_bytes(16);

		$error = false;
		if ($fpOut = fopen($dest, 'w')) {
			// Put the initialzation vector to the beginning of the file
			fwrite($fpOut, $iv);

			if ($fpIn = fopen($source, 'rb')) {
				while (!feof($fpIn)) {
					$plaintext = fread($fpIn, 16 * FILE_ENCRYPTION_BLOCKS);
					$ciphertext = openssl_encrypt($plaintext, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $iv);
					// Use the first 16 bytes of the ciphertext as the next initialization vector
					$iv = substr($ciphertext, 0, 16);
					fwrite($fpOut, $ciphertext);
				}

				fclose($fpIn);
			} else {
				$error = true;
			}
	
			fclose($fpOut);
		} else {
			$error = true;
		}

		return $error ? false : $dest;
	}


	static function decrypt($key , $source, $dest) {
		$key = substr(sha1($key, true), 0, 16);

		$error = false;
		if ($fpOut = fopen($dest, 'w')) {
			if ($fpIn = fopen($source, 'rb')) {
				// Get the initialzation vector from the beginning of the file
				$iv = fread($fpIn, 16);
				while (!feof($fpIn)) {
					// we have to read one block more for decrypting than for encrypting
					$ciphertext = fread($fpIn, 16 * (FILE_ENCRYPTION_BLOCKS + 1)); 
					$plaintext = openssl_decrypt($ciphertext, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $iv);
					// Use the first 16 bytes of the ciphertext as the next initialization vector
					$iv = substr($ciphertext, 0, 16);
					fwrite($fpOut, $plaintext);
				}
				fclose($fpIn);
			} else {
				$error = true;
			}
			fclose($fpOut);
		} else {
			$error = true;
		}

		return $error ? false : $dest;
	}
}
?>